//
//  MCSourceListGenericListView.h
//  MCApplication
//
//  Created by Michael Clark on 07/07/2005.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCSourceListAbstractListView.h"
#import "MCTVToolbarButton.h"

@class MCTVToolbarView,MCArrayController;

@class MCTableView;
@interface MCSourceListGenericListView : MCSourceListAbstractListView {
	IBOutlet MCTableView*         tableView;
	IBOutlet MCTVToolbarView*     toolbarView;
	IBOutlet MCArrayController*   arrayController;
	NSMenu   *addMenu;

	// Configurable Task SourceListsHack
	IBOutlet NSWindow*    customTaskDefaultSourceList;
	IBOutlet NSArrayController*  configurableTaskArrayController;
}

// Utility methods
- (void)processSelectionChange;
- (void)refreshSelectedSourceLists;
	// Forces the view to refresh the sourcelists that are being displayed
- (void)refreshSourceListsDisplay;

- (BOOL)canAdd;
- (BOOL)canModify;
- (BOOL)canRemove;
- (BOOL)canClearDumbList;

	//// Actions
//- (IBAction)add: (id)sender;
- (IBAction)newList: (id)sender;
- (IBAction)newSmartList:(id)sender;

- (IBAction)modify: (id)sender;
- (IBAction)remove: (id)sender;
- (IBAction)clearDumbList: (id)sender;

- (IBAction)addSourcelistToShortcuts:(id)sender;

- (void)setupToolbar;

// Configurable Task SourceListsHack
- (IBAction)closeConfigurableTaskSourceListsSheet: (id)sender;

@end
